package action.article;
import data.*;
import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;

/**
 * Just for forwarding to create article form
 * 
 * @author Roland Krner
 *
 */
@Results({
	@Result(name="success", value="/article/createArticle.jsp", type=ServletDispatcherResult.class),
	@Result(name="error", value="error.action", type=ServletRedirectResult.class)
})
@Namespace(value="/")
public class NewArticleAction{

	/**
	 * Just for forwarding to create article form
	 * 
	 * @return success
	 * 			error, if user has no permission
	 */
	public String execute(){
		
		User user = (User) ActionContext.getContext().getSession().get("user");
		
		if(user == null)
			return "error";
		else
			return "success";
	}
	
}
