package action.event;

import helpers.StringHelper;

import java.util.List;

import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.Comment;
import data.Event;
import data.User;

import exception.MissingValueException;
import exception.NoSuchEventException;

/**
 * Adds a comment to given event
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "eventDetail.action?id=${id}", type = ServletRedirectResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class),
		@Result(name = "input", value = "/event/eventDetail.jsp", type = ServletDispatcherResult.class) })
@Namespace(value = "/")
@Validation
public class AddEventCommentAction {

	private int id;
	private String comment;
	private Event event;
	private List<Comment> comments;

	private User user;

	/**
	 * Adds a comment to a given event.
	 * 
	 * @return success, if comment was added <br>
	 *         error, if user has no permission or event doesn't exist <br>
	 *         input, if values are missing
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");
		if (user == null)
			return "error";

		comment = StringHelper.stripHtml(comment);
		comment = StringHelper.nl2br(comment);

		try {
			try {
				DAOManager.getCommentDAO().createEventComment(user, " ",
						comment, id);
			} catch (NoSuchEventException e) {
				return "error";
			}
		} catch (MissingValueException e) {
			return "input";
		}
		comment = null;
		try {
			setEvent(DAOManager.getEventDAO().getById(id));
		} catch (NoSuchEventException e) {
			return "error";
		}
		setComments(event.getComments());

		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	@RequiredStringValidator(message = "Text bentigt!")
	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public Event getEvent() {
		return event;
	}

	public void setEvent(Event event) {
		this.event = event;
	}

	public List<Comment> getComments() {
		return comments;
	}

	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}

}
