package action.event;

import helpers.StringHelper;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import manager.DAOManager;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.*;
import exception.MissingValueException;
import exception.NoSuchLocationException;

/**
 * Uses Form data to create a new Event
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "frontpage.action", type = ServletRedirectResult.class),
		@Result(name = "input", value = "/event/createEvent.jsp", type = ServletDispatcherResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
@Validation
public class CreateEventAction {

	private User owner, user;
	private Date creationDate;
	private Date startDate, endDate, startTime, endTime;
	private String title, text;
	private File image;
	private String imageFileName, imageContentType;
	private Location location;
	private List<Tag> availableTags;
	private List<Tag> tags;
	private int tagID;
	private int locationID;
	private List<Location> locationList;
	private boolean addLocation;
	private String locationName, locationStreet, locationCity,
			locationDescription, locationLink, locationPostalCode;

	/**
	 * Uses Form data to create a new Event
	 * 
	 * @return success, if event was created<br>
	 *         error, if user has no permission or event wasn't created<br>
	 *         input, if values are missing
	 */
	public String execute() {
		Image tempImage = null;

		user = (User) ActionContext.getContext().getSession().get("user");

		// set time
		Date saveStartDate, saveEndDate;

		if(startDate != null && startTime != null)
			saveStartDate = helpers.DateHelper.addTimeToDate(startDate, startTime);
		else
			saveStartDate = startDate;
		
		if(endDate != null && endTime != null)
			saveEndDate = helpers.DateHelper.addTimeToDate(endDate, endTime);
		else
			saveEndDate = endDate;

		if (user == null)
			return "error";

		if (addLocation == true) {

			try {
				location = DAOManager.getLocationDAO().createAndStore(
						locationName, locationStreet, locationPostalCode,
						locationCity, locationDescription, locationLink);
			} catch (MissingValueException e) {
				return "input";
			}

		} else {

			try {
				location = DAOManager.getLocationDAO().getById(locationID);
			} catch (NoSuchLocationException e2) {
				try {
					setLocationList(DAOManager.getLocationDAO().getList());
				} catch (NoSuchLocationException e1) {
					return "input";
				}
				return "input";
			}

		}
		if (image != null) {

			String dataDir = ServletActionContext.getServletContext()
					.getRealPath("/WEB-INF/upload/");

			String fileName = UUID.randomUUID().toString();
			File saveFile = new File(dataDir, fileName);
			image.renameTo(saveFile);

			try {
				tempImage = DAOManager.getImageDAO().createAndStore(
						image.getName(), fileName, dataDir, imageContentType);
			} catch (MissingValueException e) {
				// do nothing
			}

		}
		
		text = StringHelper.stripHtml(text);
		text = StringHelper.nl2br(text);


		try {
			DAOManager.getEventDAO().createAndStore(user, title, text,
					location, tempImage, saveStartDate, saveEndDate);
		} catch (MissingValueException e) {
			return "error";
		}
		try {
			setLocationList(DAOManager.getLocationDAO().getList());
		} catch (NoSuchLocationException e1) {
			// ignore
		}

		return "success";
	}

	public User getOwner() {
		return owner;
	}

	public void setOwner(User owner) {
		this.owner = owner;
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	@RequiredStringValidator(message = "Kein Titel vorhanden!")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public File getImage() {
		return image;
	}

	public void setImage(File image) {
		this.image = image;
	}

	// TODO: Struts-Bug: select geht nicht mit validation
	// @RequiredFieldValidator(message="Location muss ausgewhlt werden!")
	public Location getLocation() {
		return location;
	}

	public void setLocation(Location location) {
		this.location = location;
	}

	public List<Tag> getAvailableTags() {
		return availableTags;
	}

	public void setAvailableTags(List<Tag> availableTags) {
		this.availableTags = availableTags;
	}

	public List<Tag> getTags() {
		return tags;
	}

	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}

	public int getTagID() {
		return tagID;
	}

	public void setTagID(int tagID) {
		this.tagID = tagID;
	}

	public List<Location> getLocationList() {
		return locationList;
	}

	public void setLocationList(List<Location> locationList) {
		this.locationList = locationList;
	}

	public int getLocationID() {
		return locationID;
	}

	public void setLocationID(int locationID) {
		this.locationID = locationID;
	}

	public String getImageFileName() {
		return imageFileName;
	}

	public void setImageFileName(String imageFileName) {
		this.imageFileName = imageFileName;
	}

	public String getImageContentType() {
		return imageContentType;
	}

	public void setImageContentType(String imageContentType) {
		this.imageContentType = imageContentType;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public void setAddLocation(boolean addLocation) {
		this.addLocation = addLocation;
	}

	public String getLocationName() {
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = locationName;
	}

	public String getLocationStreet() {
		return locationStreet;
	}

	public void setLocationStreet(String locationStreet) {
		this.locationStreet = locationStreet;
	}

	public String getLocationCity() {
		return locationCity;
	}

	public void setLocationCity(String locationCity) {
		this.locationCity = locationCity;
	}

	public String getLocationDescription() {
		return locationDescription;
	}

	public void setLocationDescription(String locationDescription) {
		this.locationDescription = locationDescription;
	}

	public boolean isAddLocation() {
		return addLocation;
	}

	public String getLocationLink() {
		return locationLink;
	}

	public void setLocationLink(String locationLink) {
		this.locationLink = locationLink;
	}

	public void setLocationPostalCode(String locationPostalCode) {
		this.locationPostalCode = locationPostalCode;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getLocationPostalCode() {
		return locationPostalCode;
	}

}
