package action.event;

import helpers.StringHelper;

import java.util.Calendar;
import java.util.Date;
import org.apache.struts2.config.*;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;

import manager.DAOManager;

import data.Event;
import data.User;
import exception.NoSuchEventException;
import exception.NoSuchLocationException;

/**
 * Takes Form data to edit an event
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "frontpage.action", type = ServletRedirectResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
public class DoEditEventAction {

	private Event event;
	private Date startDate, endDate, startTime, endTime;
	private int id, locationID;

	private User user;

	/**
	 * Takes Form data to edit an event
	 * 
	 * @return success, if event was created<br>
	 *         error, if user has no permission, location could not be retrieved
	 *         or event doesn't exist
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		if (user == null)
			return "error";

		Event event;

		try {
			event = DAOManager.getEventDAO().getById(id);
		} catch (NoSuchEventException e) {
			return "error";
		}
		this.event.setText(StringHelper.stripHtml(this.event.getText()));
		this.event.setText(StringHelper.nl2br(this.event.getText()));

		Date saveStartDate, saveEndDate;

		if(startDate != null && startTime != null)
			saveStartDate = helpers.DateHelper.addTimeToDate(startDate, startTime);
		else
			saveStartDate = startDate;
		
		if(endDate != null && endTime != null)
			saveEndDate = helpers.DateHelper.addTimeToDate(endDate, endTime);
		else
			saveEndDate = endDate;

		event.setEndDate(saveEndDate);
		event.setStartDate(saveStartDate);
		event.setTitle(this.event.getTitle());
		event.setText(this.event.getText());
		try {
			event.setLocation(DAOManager.getLocationDAO().getById(locationID));
		} catch (NoSuchLocationException e) {
			return "error";
		}
		event.setLastEdit(Calendar.getInstance().getTime());

		return "success";
	}

	public Event getEvent() {
		return event;
	}

	public void setEvent(Event event) {
		this.event = event;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getLocationID() {
		return locationID;
	}

	public void setLocationID(int locationID) {
		this.locationID = locationID;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

}
