package action.event;

import helpers.PagerHelper;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import manager.DAOManager;
import data.*;
import exception.NoSuchEventException;

import com.opensymphony.xwork2.ActionContext;

/**
 * Retrieves Data of a given event-id
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class),
		@Result(name = "success", value = "/event/eventDetail.jsp", type = ServletDispatcherResult.class) })
@Namespace(value = "/")
public class EventDetailAction {

	private int id;
	private Event event;
	private Location location;
	private List<Comment> comments;
	private List<Tag> tags;
	private User user;
	private ArrayList<Integer> commentPages;
	private int commentPage;

	/**
	 * Retrieves Data of a given event-id.
	 * 
	 * @return success, data was recieved<br>
	 *         error, if event doesn't exist
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		try {
			setEvent(DAOManager.getEventDAO().getById(id));
		} catch (NoSuchEventException e) {
			return "error";
		}

		location = event.getLocation();
		comments = event.getComments();

		commentPages = new ArrayList<Integer>();

		PagerHelper.fillArray(comments, commentPages, 3);

		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Event getEvent() {
		return event;
	}

	public void setEvent(Event event) {
		this.event = event;
	}

	public Location getLocation() {
		return location;
	}

	public void setLocation(Location location) {
		this.location = location;
	}

	public List<Comment> getComments() {
		return comments;
	}

	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}

	public List<Tag> getTags() {
		return tags;
	}

	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public ArrayList<Integer> getCommentPages() {
		return commentPages;
	}

	public void setCommentPages(ArrayList<Integer> commentPages) {
		this.commentPages = commentPages;
	}

	public int getCommentPage() {
		return commentPage;
	}

	public void setCommentPage(int commentPage) {
		this.commentPage = commentPage;
	}
}
