package action.event;

import java.util.List;

import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import data.Event;
import exception.NoSuchEventException;

/**
 * Retrieves upcoming 20 events for rss-display
 * 
 * @author Roland Krner
 * 
 */
@Result(name = "success", value = "/event/eventFeed.jsp", type = ServletDispatcherResult.class)
@Namespace(value = "/")
public class EventFeedAction {

	private List<Event> events;

	/**
	 * Retrieves upcoming 20 events for rss-display.
	 * 
	 * @return success
	 */
	public String execute() {

		try {
			events = DAOManager.getEventDAO().getUpcoming(20);
		} catch (NoSuchEventException e) {

		}

		return "success";
	}

	public List<Event> getEvents() {
		return events;
	}

	public void setEvents(List<Event> events) {
		this.events = events;
	}

}
