package action.event;

import java.util.List;

import data.*;
import exception.NoSuchLocationException;
import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;

/**
 * Forward to create event form
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "/event/createEvent.jsp", type = ServletDispatcherResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
public class NewEventAction {

	private List<Location> locationList;
	private Long selectedLocation;

	/**
	 * Forward to create event form, retrieves locationlist
	 * 
	 * @return success<br>
	 *         error, if user has no permission
	 */
	public String execute() {

		User user = (User) ActionContext.getContext().getSession().get("user");
		if (user == null)
			return "error";

		try {
			setLocationList(DAOManager.getLocationDAO().getList());
		} catch (NoSuchLocationException e) {

		}
		return "success";
	}

	public List<Location> getLocationList() {
		return locationList;
	}

	public void setLocationList(List<Location> locationList) {
		this.locationList = locationList;
	}

	public Long getSelectedLocation() {
		return selectedLocation;
	}

	public void setSelectedLocation(Long selectedLocation) {
		this.selectedLocation = selectedLocation;
	}
}
