package action.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;

import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.dispatcher.StreamResult;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.util.ServletContextAware;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;

import data.Image;

/**
 * Retrieves file by given id and sends the filestream
 * 
 * @author Roland Krner
 * 
 */
@SuppressWarnings("serial")
@Result(name = "success", type = StreamResult.class, value = "fileInputStream")
@Namespace(value = "/")
public class GetImageAction extends ActionSupport implements
		ServletResponseAware, ServletContextAware {

	private int id;
	private FileInputStream fileInputStream;

	private HttpServletResponse servletResponse;
	private ServletContext servletContext;

	/**
	 * Retrieves file by given id and sends the file stream.
	 * 
	 * @return FileInputStream
	 * @throws Exception
	 */
	public InputStream getFileInputStream() throws Exception {

		try {
			Image image = DAOManager.getImageDAO().getById(id);

			String filename = image.getFileName();
			String path = image.getPath();
			String mimeType = image.getMimeType();
			String name = image.getName();

			File file = new File(path, filename);

			com.opensymphony.xwork2.Result result = ActionContext.getContext()
					.getActionInvocation().getResult();
			StreamResult streamResult = (StreamResult) result;
			streamResult.setContentType(mimeType);
			streamResult.setInputName(name);

			fileInputStream = new FileInputStream(file);

			return fileInputStream;
		} catch (RuntimeException e) {
			return null;
		}
	}

	public void setServletResponse(HttpServletResponse servletResponse) {
		this.servletResponse = servletResponse;
	}

	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public HttpServletResponse getServletResponse() {
		return servletResponse;
	}

	public ServletContext getServletContext() {
		return servletContext;
	}

	public void setFileInputStream(FileInputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

}
