package action.login;

import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;

import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.RoleEnum;
import exception.MissingValueException;
import exception.NoSuchUserException;

/**
 * Creates Account with given Form data
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "/login/loginForm.jsp", type = ServletDispatcherResult.class),
		@Result(name = "input", value = "/login/createAccount.jsp", type = ServletDispatcherResult.class) })
@Namespace(value = "/")
@Validation
public class DoCreateAccountAction {

	private String name, firstName, email, nickName, password;

	/**
	 * Creates Account with given Form data.
	 * 
	 * @return success, if account was created<br>
	 *         input, if nickname already exists or user couldn't be created
	 */
	public String execute() {

		try {
			if (DAOManager.getUserDAO().getByNickName(nickName) != null) {
				nickName = "";
				return "input";
			}
		} catch (NoSuchUserException e) {
		}

		try {
			DAOManager.getUserDAO().createAndStore(firstName, name, email,
					nickName, password, RoleEnum.REGISTERED);
		} catch (MissingValueException e) {
			return "input";
		}

		return "success";
	}

	@RequiredStringValidator(message = "Name bentigt")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@RequiredStringValidator(message = "Vorame bentigt")
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	@EmailValidator(message = "Name bentigt")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@RequiredStringValidator(message = "Nickname bentigt")
	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	@RequiredStringValidator(message = "Passwort bentigt")
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

}
