package action.thread;

import helpers.StringHelper;
import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.User;

import exception.MissingValueException;
import exception.NoSuchEventException;
import exception.NoSuchForumThreadException;

/**
 * Adds a comment to a given thread
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "showThreads.action?id=${id}", type = ServletRedirectResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
@Validation
public class AddThreadCommentAction {

	private int id;
	private String comment;
	private User user;

	/**
	 * Adds a comment to a given thread.
	 * 
	 * @return success, if comment was added error, if user has no permission or
	 *         thread doesn't exist
	 */
	public String execute() throws NoSuchEventException {
		user = (User) ActionContext.getContext().getSession().get("user");

		if (user == null)
			return "error";

		comment = StringHelper.stripHtml(comment);
		comment = StringHelper.nl2br(comment);

		try {

			DAOManager.getCommentDAO().createForumThreadComment(user, "",
					comment, id);
		} catch (NoSuchForumThreadException e) {
			return "error";
		} catch (MissingValueException e) {
			return "error";
		}

		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	@RequiredStringValidator(message = "Text bentigt!")
	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

}
