package action.thread;

import helpers.StringHelper;
import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.*;
import exception.MissingValueException;

/**
 * Takes Form data and tries to create a new thread
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "showThreads.action", type = ServletRedirectResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
@Validation
public class DoCreateThreadAction {

	private User owner;
	private String title, text;
	private User user;

	/**
	 * Takes Form data and tries to create a new thread.
	 * 
	 * @return success, if thread was created<br>
	 *         error, if user has no permission or event couldn't be created
	 */
	public String execute() {

		user = (User) ActionContext.getContext().getSession().get("user");
		if (user == null)
			return "error";
		
		text = StringHelper.stripHtml(text);
		text = StringHelper.nl2br(text);

		try {
			DAOManager.getForumThreadDAO().createAndStore(user, title, text);
			return "success";

		} catch (MissingValueException e) {
			return "error";
		}
	}

	public User getOwner() {
		return owner;
	}

	public void setOwner(User owner) {
		this.owner = owner;
	}

	@RequiredStringValidator(message = "Kein Titel vorhanden!")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@RequiredStringValidator(message = "Ohne Text kein Thread!")
	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

}
