package action.thread;

import helpers.StringHelper;

import java.util.Calendar;
import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;

import manager.DAOManager;

import data.ForumThread;
import data.User;
import exception.NoSuchForumThreadException;

/**
 * Edits a thread by given form data
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "showThreads.action?", type = ServletRedirectResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
public class DoEditThreadAction {

	private ForumThread thread;
	private int id;
	private User user;

	/**
	 * Edits a thread by given form data.
	 * 
	 * @return success, thread was edited,<br>
	 *         error, if user has no permission or thread doesn't exist
	 */
	public String execute() {
		ForumThread thread;
		user = (User) ActionContext.getContext().getSession().get("user");

		if (user == null)
			return "error";

		try {
			thread = DAOManager.getForumThreadDAO().getById(id);
			
			this.thread.setText(StringHelper.stripHtml(this.thread.getText()));
			this.thread.setText(StringHelper.nl2br(this.thread.getText()));

			
			thread.setTitle(this.thread.getTitle());
			thread.setText(this.thread.getText());
			thread.setLastEdit(Calendar.getInstance().getTime());

		} catch (NoSuchForumThreadException e) {
			return "error";
		}

		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public ForumThread getThread() {
		return thread;
	}

	public void setThread(ForumThread thread) {
		this.thread = thread;
	}

}
