package action.thread;

import helpers.StringHelper;
import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;
import data.ForumThread;
import data.User;
import exception.NoSuchForumThreadException;

/**
 * Retrieves thread by id and redirect to edit form
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "/thread/editThread.jsp", type = ServletDispatcherResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
public class EditThreadAction {

	private ForumThread thread;
	private int id;
	private User user;

	/**
	 * Retrieves thread by id and redirect to edit form.
	 * 
	 * @return success,<br>
	 *         error, if user has no permission or thread doesn't exist
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		if (user == null)
			return "error";

		try {
			setThread(DAOManager.getForumThreadDAO().getById(id));
		} catch (NoSuchForumThreadException e) {
			return "error";
		}
		
		this.thread.setText(StringHelper.stripHtml(this.thread.getText()));


		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public ForumThread getThread() {
		return thread;
	}

	public void setThread(ForumThread thread) {
		this.thread = thread;
	}

}
