package data;

import java.util.Date;
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.LinkedList;


/**
 * Presents an event. An event is usually written by a registered user
 * and has some tags, comments, a image, a location, a startdate and an enddate.  
 *
 * 
 * @author Ferdinand Kaiser, 07.05.08
 */
public class Event extends Entry{


	private List<Comment> comments=new LinkedList();
	private Set<Tag> tags=new HashSet();
	private Location location;
	private Image image;
	private Date startDate,endDate;
	
	public Event(){
		
	}

	/**
	 * 
	 * @param owner owner of the event
	 * @param title title of the event
	 * @param creationDate date when event was created
	 * @param text text of the event
	 * @param lastEdit date when event was last edited
	 * @param visible true if event is to be displayed
	 * @param location location where event takes place
	 * @param image image assigned to event , flyer etc
	 * @param startDate date when event starts
	 * @param endDate date when event ends
	 */
	public Event(User owner, String title, Date creationDate, String text,
			Date lastEdit, boolean visible, Location location, Image image, Date startDate, Date endDate) {
		super(owner, title, creationDate, text, lastEdit, visible);
		this.location = location;
		this.image = image;
		this.startDate=startDate;
		this.endDate=endDate;
	}	
	
	/**
	 * 
	 * @return location associated to the event
	 */
	public Location getLocation() {
		return location;
	}
	
	/**
	 * sets the location associated to the event
	 * @param location
	 */
	public void setLocation(Location location) {
		this.location = location;
	}
	
	/**
	 * 
	 * @return image associated to the event
	 */
	public Image getImage() {
		return image;
	}
	
	/**
	 * sets the image associated to the event
	 * @param image
	 */
	public void setImage(Image image) {
		this.image = image;
	}

	/**
	 * 
	 * @return a set of tags associated to this event
	 */
	public Set<Tag> getTags() {
		return tags;
	}

	/**
	 * sets the set of tags associated to this event, only to be used by Hibernate!
	 * @param tags
	 */
	public void setTags(Set<Tag> tags) {
		this.tags = tags;
	}

	/**
	 * 
	 * @return date when event starts
	 */
	public Date getStartDate() {
		return startDate;
	}	
	
	/**
	 * sets the date when event starts 
	 * @param startDate
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	
	/**
	 * 
	 * @return date when event ends
	 */
	public Date getEndDate() {
		return endDate;
	}

	/**
	 * sets date when event ends
	 * @param endDate 
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	/**
	 *
	 * @return list of comments associated to event
	 */
	public List<Comment> getComments() {
		return comments;
	}


	/**
	 * sets the set of comments associated to this event, only to be used by Hibernate!
	 * @param tags
	 */	
	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}

}

