package data;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
/**
 * Presents a ForumThread, a ForumThread is a simple Entry with some comments. 
 * @author Ferdinand Kaiser
 */
public class ForumThread extends Entry{
	private Date lastUpdated;
	private List<Comment> comments=new LinkedList();
	
	
	
	public ForumThread() {
		super();
	}

	/**
	 * 
	 * @param owner the threads owner
	 * @param title title of the thread
	 * @param creationDate date when thread was created
	 * @param text the threads content
	 * @param lastEdit date when thread was last edited
	 * @param lastEdit date when the whole thread was last updated (edited or comment added)
	 * @param visible
	 */
	public ForumThread(User owner, String title, Date creationDate,
			String text, Date lastEdit, Date lastUpdated, boolean visible) {
		super(owner, title, creationDate, text, lastEdit, visible);
		this.lastUpdated=lastUpdated;
	}

	/**
	 * 
	 * @return the Date when thread was last updated. E.g. text edited by owner, or comment added by others
	 */
	public Date getLastUpdated() {
		return lastUpdated;
	}

	/**
	 * 
	 * @param lastUpdated	/**
	 * 
	 * @return sets the Date when thread was last updated. E.g. text edited by owner, or comment added by others
	 */
	public void setLastUpdated(Date lastUpdated) {
		this.lastUpdated = lastUpdated;
	}

	/**
	 *
	 * @return list of comments associated to  this forumthread
	 */
	public List<Comment> getComments() {
		return comments;
	}

	/**
	 * sets the set of comments associated to this forumthread, only to be used by Hibernate!
	 * @param tags
	 */	
	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}
	
	
	
	
}
