package data;

/**
 * Presents a image-record, with a name displayed to the user, a name in the filesystem, a path and a
 * mimetype.
 * 
 * @author Ferdinand Kaiser, 05.05.2008
 */
public class Image {
	
	private int id;
	private String name;
	private String fileName;
	private String path;
	private String mimeType;
	
	public Image(){
		
	}

	/**
	 * 
	 * @param name name displayed to the user
	 * @param fileName name in the filesystem
	 * @param path path in the filesystem
	 * @param mimeType mimetype
	 */
	public Image(String name, String fileName, String path,	String mimeType) {
		this.name = name;
		this.fileName = fileName;
		this.path = path;
		this.mimeType = mimeType;
	}	
	
	/**
	 * 
	 * @return unique id
	 */
	public int getId() {
		return id;
	}
	
	/**
	 * sets the unique ide, only to be used by Hibernate!
	 * @param id 
	 */
	private void setId(int id) {
		this.id = id;
	}

	/**
	 * 
	 * @return name displayed to the user
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * sets name displayed to the user
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	
	/**
	 * 
	 * @return name in the filesystem
	 */
	public String getFileName() {
		return fileName;
	}
	
	/**
	 * sets name in the filesystem
	 * @param fileName
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	
	/**
	 * 
	 * @return path in the filesystem
	 */
	public String getPath() {
		return path;
	}
	
	/**
	 * sets path in the filesystem
	 * @param path
	 */
	public void setPath(String path) {
		this.path = path;
	}
	
	/**
	 * 
	 * @return mimetype of the file
	 */
	public String getMimeType() {
		return mimeType;
	}
	
	/**
	 * sets mimetype of the file
	 * @param mimeType
	 */
	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

}
