package data;

import java.util.Date;

/**
 * Presents a user of the system.
 * 
 * @author Ferdinand Kaiser
 *
 */
public class User {

	private int id;
	private String firstName;
	private String lastName;
	private String emailAddress;
	private String nickName;
	private String password;
	private Date lastLogin;
	private Date creationDate;
	private RoleEnum role;
	private boolean visible;
	
	public User(){
		
	}
	
	/**
	 * 
	 * @param firstName firstname of the user
	 * @param lastName lastname of the user
	 * @param emailAddress emailaddress of the user
	 * @param nickName nickname of the user
	 * @param password the users password
	 * @param lastLogin date of the last login
	 * @param creationDate date when useraccount was created
	 * @param role the role which is assigned to the user
	 * @param visible true if the user is visible (login allowed etc)
	 */
	public User(String firstName, String lastName, String emailAddress,
			String nickName, String password, Date lastLogin,
			Date creationDate, RoleEnum role, boolean visible) {
		this.firstName = firstName;
		this.lastName = lastName;
		this.emailAddress = emailAddress;
		this.nickName = nickName;
		this.password = password;
		this.lastLogin = lastLogin;
		this.creationDate = creationDate;
		this.visible = visible;
		this.role = role;
	}	
	
	/**
	 * 
	 * @return unique id
	 */
	public int getId() {
		return id;
	}

	/**
	 * sets the unique it, only to be used by Hibernate!
	 * @param id
	 */
	private void setId(int id) {
		this.id = id;
	}
	
	/**
	 * 
	 * @return firstname of the user
	 */
	public String getFirstName() {
		return firstName;
	}
	
	/**
	 * sets firstname of the user
	 * @param firstName
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	/**
	 * 
	 * @return lastname of the user
	 */
	public String getLastName() {
		return lastName;
	}
	
	/**
	 * sets lastname of the user
	 * @param lastName
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	/**
	 * 
	 * @return users emailaddress
	 */
	public String getEmailAddress() {
		return emailAddress;
	}
	
	/**
	 * sets users emailaddress
	 * @param emailAddress
	 */
	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}
	
	/**
	 * 
	 * @return users nickname
	 */
	public String getNickName() {
		return nickName;
	}
	
	/**
	 * sets users nickname
	 * @param nickName
	 */
	public void setNickName(String nickName) {
		this.nickName = nickName;
	}
	
	/**
	 * 
	 * @return last date user logged in
	 */
	public Date getLastLogin() {
		return lastLogin;
	}
	
	/**
	 * sets last date user logged in
	 * @param lastLogin
	 */
	public void setLastLogin(Date lastLogin) {
		this.lastLogin = lastLogin;
	}
		
	/**
	 * 
	 * @return date when useraccount was created
	 */
	public Date getCreationDate() {
		return creationDate;
	}
	
	/**
	 * sets date when useraccount was created
	 * @param creationDate
	 */
	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}
		
	/**
	 * 
	 * @return the users password
	 */
	public String getPassword() {
		return password;
	}
	
	/**
	 * sets the users password
	 * @param password
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	
	/**
	 * 
	 * @return true if the user is allowed to login etc.
	 */
	public boolean isVisible() {
		return visible;
	}
	
	/**
	 *  set true if the user is allowed to login etc.
	 * @param visible
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}

	/**
	 * 
	 * @return the role which is assigned to the user
	 */
	public RoleEnum getRole() {
		return role;
	}

	/**
	 * sets the role which is assigned to the user
	 * @param role
	 */
	public void setRole(RoleEnum role) {
		this.role = role;
	}

}
