package helpers;

import java.util.ArrayList;
import java.util.List;

/**
 * Static methods for pager.
 * 
 * @author Roland Krner
 *
 */
public class PagerHelper {
	
	/**
	 * Takes a list of entries and creates an integer list with ascending integer values for use as a
	 * pager with struts2-iterator tag.
	 * 
	 * @param entries A list of entries that should be presented as a pager
	 * @param list The Target list, must be empty
	 * @param size The amount of entries to be shown on one page
	 */
	@SuppressWarnings("unchecked")
	public static void fillArray(List entries, ArrayList<Integer> list, int size) {
		int k = 0;
		if (entries != null) {
			for (int i = 0; i < entries.size(); i = i + size) {
				list.add(k);
				k++;
			}
		}
	}
}

