package repository;

import java.util.List;
import org.hibernate.PropertyValueException;
import org.hibernate.Session;
import exception.*;
import data.Image;


/**
 * DAO providing basic methods for managing Imageclass-Objects.
 * @author Ferdinand Kaiser
 *
 */
public class ImageDAO {

	private Session session;

	/**
	 * This constructor is used by the DAOManager, its a factory that initializes all DAOs with the current session.
	 * Note that every session.commit() will close the session, the DAOManager must initialize the DAOs again.
	 * Use a Open Session in View pattern to prevent this.
	 */
	public ImageDAO(){
		this.session=HibernateUtil.getSessionFactory().getCurrentSession();
	}

	/**
	 * Creates image object and saves it
	 * @param name name that is displayed to the user
	 * @param fileName name within the filesystem
	 * @param path path in the filesystem
	 * @param mimeType mimetype of the file
	 * @return image instance
	 * @throws MissingValueException if there is a not-null value that is null	 *	 * 
	 */
	public Image createAndStore( String name, String fileName, String path, String mimeType)
	throws MissingValueException{
		Image image=new Image(name, fileName, path, mimeType);
		try{
			session.save(image);
		}
		catch(PropertyValueException ex){
			throw new MissingValueException("A not-null value is possibly null!");
		}		
		return image;
	}

	/**
	 * 
	 * @return a list of all images
	 * @throws NoSuchImageException if there are no images
	 */
	public List<Image> getList() throws NoSuchImageException{
		List<Image> result=session.createQuery("from Image").list();
		if (result.size()==0) throw new NoSuchImageException();
		return result;
	}

	/**
	 * gets an image by its unique id
	 * @param id unique id
	 * @return image
	 * @throws NoSuchImageException if there isn't an image with this id
	 */
	public Image getById(int id) throws NoSuchImageException{
		Image result= (Image)session.get(Image.class,id);
		if (result==null) throw new NoSuchImageException();
		return result;		
	}

	//TODO: nur zum testen
	public String getServerPath(int id) throws NoSuchImageException{
		Image image = getById(id);

		return image.getPath() + image.getFileName();
	}

}
