package test;

import repository.HibernateUtil;
import repository.DateUtil;
import org.hibernate.*;
import data.*;



import java.util.Date;
import manager.DAOManager;
import exception.*;

/**
 *  Collection Mapping  - ok
 *  Inheritance Mapping - ok
 *  Association Mapping - ok
 * 
 * 
 * @author Ferdinand Kaiser, 06.04.08
 *
 */
public class ModellTestInheritance {



	public static void main(String[] args)
	{
		Session session=HibernateUtil.getSessionFactory().getCurrentSession();
		DAOManager.init();
		// Storing test
		session.beginTransaction();

		User user=null;
		User user2=null;
		Image image=null;
		Location location=null;
		Article article=null;
		
		try{
			user=DAOManager.getUserDAO().createAndStore("zwo","bot","zwo@bot.de","zwobot","123",RoleEnum.ADMIN);	
			user2=DAOManager.getUserDAO().createAndStore("elektra","kitty","elek@rx.de","kittE","323",RoleEnum.MODERATOR);
			image=DAOManager.getImageDAO().createAndStore("mega.jpg","image00.jpg", "images/image00.jpg","image/jpeg");
			location=DAOManager.getLocationDAO().createAndStore("Megadrom", "Astronautenallee", "01283", "Radebeul", "Groraumdisco", "www.mgadrm.de");
			article=DAOManager.getArticleDAO().createAndStore( user, "FHB News", "Manga+Anime-Treffen durch massiven Blitzeinschlag gestrt.", image);
		}
		catch(MissingValueException ex){
			ex.printStackTrace();
		}

		try{
			DAOManager.getTagDAO().createArticleTag("0815", article.getId());
			DAOManager.getTagDAO().createArticleTag("God", article.getId());
			DAOManager.getTagDAO().createArticleTag("Essen", article.getId());
			DAOManager.getCommentDAO().createArticleComment(user2, "Kommentar 1", "yeah", article.getId());
			DAOManager.getCommentDAO().createArticleComment(user2, "Kommentar 2", "yeah", article.getId());
			DAOManager.getCommentDAO().createArticleComment(user2, "Kommentar 3", "yeah", article.getId());
		}
		catch(NoSuchArticleException ex){
			ex.printStackTrace();
		}
		catch(MissingValueException ex){
			ex.printStackTrace();
		}
		
		Event event=DAOManager.getEventDAO().createAndStore(user, "Party Megadrom", "HDH begrt alle Raver",  location, image, DateUtil.get(2008,01,01), DateUtil.get(2008,03,01));

		try{
			DAOManager.getTagDAO().createEventTag("Canaveral", event.getId());
			DAOManager.getTagDAO().createEventTag("God", event.getId());
			DAOManager.getTagDAO().createEventTag("Lab", event.getId());
			DAOManager.getCommentDAO().createEventComment(user2, "Kommentar I", "...", event.getId());
			DAOManager.getCommentDAO().createEventComment(user2, "Kommentar II", "...", event.getId());
			DAOManager.getCommentDAO().createEventComment(user2, "Kommentar III", "...", event.getId());
		}
		catch(NoSuchEventException ex){
			ex.printStackTrace();
		}
		catch(MissingValueException ex){
			ex.printStackTrace();
		}

		ForumThread thread=null; 
		try{
			thread=DAOManager.getForumThreadDAO().createAndStore(user, "Golem.de: Iphone 3G vorgestellt", "Auf der WWDC wurde heute ....");
			DAOManager.getCommentDAO().createForumThreadComment(user2, "Wie teuer?", "Wieviel kostet es in der Herstellung?", thread.getId());
			DAOManager.getCommentDAO().createForumThreadComment(user2, "AGPS?", "GPS oder AGPS?", thread.getId());
			DAOManager.getCommentDAO().createForumThreadComment(user2, "Ohne Windows Mobile wird das nix", "n/t", thread.getId());
		}
		catch(NoSuchForumThreadException ex){
			ex.printStackTrace();
		}
		catch(MissingValueException ex){
			ex.printStackTrace();
		}
		
		session.getTransaction().commit();

		// Retrieving test

		session=HibernateUtil.getSessionFactory().getCurrentSession();
		DAOManager.init();
		session.beginTransaction();
		try{
			Event event2=DAOManager.getEventDAO().getList().get(0);		
			MappingTestView.displayEvent(event2);
		}
		catch(NoSuchEventException ex){
			ex.printStackTrace();
		}

		try{
			Article article2=DAOManager.getArticleDAO().getList().get(0);
			MappingTestView.displayArticle(article2);
		}
		catch(NoSuchArticleException ex){
			ex.printStackTrace();
		}

		try{
			MappingTestView.displayArticle(DAOManager.getArticleDAO().getByTag("God").get(0));	
		}
		catch(EmptyResultException ex){
			ex.printStackTrace();
		}

		try{
			ForumThread thread2=DAOManager.getForumThreadDAO().getList().get(0);
			MappingTestView.displayForumThread(thread2);
		}
		catch(NoSuchForumThreadException ex){
			ex.printStackTrace();
		}

		session.getTransaction().commit();

	}



}

