package mks;

import hudson.FilePath;
import hudson.scm.SCM;
import java.io.PrintStream;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

/**
 *
 * @author James Sheets
 */
public class MksUtils
{

    /** Output MKS rlog to an XML structure we can Digest **/
    public static final String RLOG_FORMAT = String.format(
            "\n<modification>\n" +
                "\t<action>Edit</action>\n" +
                "\t<member>{membername}</member>\n" +
                "\t<revision>{revision}</revision>\n" +
                "\t<date>{date}</date>\n" +
                "\t<cpid>{cpid}</cpid>\n" +
                "\t<cpDesc>{cpsummary}</cpDesc>\n" +
                "\t<mksuser>{author}</mksuser>\n" +
                "\t<msg>{description}</msg>\n" +
            "</modification>" );
    
    /** Date format used when calling rlog command **/
    public static final String RLOG_SEARCH_DATE_FORMAT = "MMM dd, yyyy hh:mm:ss a";

    /** Date format for rlog output **/
    public static final String RLOG_OUTPUT_DATE_FORMAT = "MM/dd/yyyy kk:mm:ss";


    public static FilePath getSandboxLocation(FilePath workspace, mks.config.Project project)
    {
        if ( StringUtils.isBlank( project.getSandboxName() ) )
            throw new IllegalArgumentException("No sandbox name specified for project");
        
        return new FilePath( workspace, project.getSandboxName() );
    }

    
//    public static FilePath getSandboxResourceFile(FilePath workspace, mks.config.Project project)
//    {
//        return new FilePath( getSandboxLocation( workspace, project ), "project.pj" );
//    }


    /**
     * A quick and dirty test to see if this directory appears to be a registered
     * MKS sandbox.  We specifically don't care if it actually is not here.
     * 
     * @param sandboxPath The FilePath to the sandbox
     * @return If the FilePath exists, and has a project.pj file in it
     */
    public static boolean appearsIsRegisteredSandbox(FilePath sandboxPath)
    {
        try
        {
            return sandboxPath.exists() && sandboxPath.child("project.pj").exists();
        } 
        catch (Exception _)
        {
            //Logger.getLogger(MksUtils.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }


    public static String formatRlogSeachDate(Date date)
    {
        return FastDateFormat.getInstance(MksUtils.RLOG_SEARCH_DATE_FORMAT).format( date );
    }


    public static String formatRlogOutputDate(Date date)
    {
        return FastDateFormat.getInstance(MksUtils.RLOG_OUTPUT_DATE_FORMAT).format( date );
    }
    
    
    public static boolean isUsingMksSandbox(SCM scm, PrintStream logger)
    {
        // Only supported for MKS Source Integrity SCM
        if ( !(scm instanceof MksScm) )
        {
            logger.println( "MKS Source Integrity plugin doesn't support labeling for VCS: "+ scm.toString() + "." );
            return false;
        }

        return true;
    }
    
    
    public static String stripEnvVarTokens(String key)
    {
        String tkey = key.trim();
        if (tkey.startsWith("${") && tkey.endsWith("}"))
        {
            return tkey.substring(2, tkey.length()-1);
        }
        else if (tkey.startsWith("$"))
        {
            return tkey.substring(1);
        }
        else
        {
            return key;
        }
    }
    
}
