package mks.changelog;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import org.apache.commons.lang.StringUtils;


/**
 * Generates MksChangeLogEntry classes from our SCM change logs
 *
 * @author James Sheets
 */
public class MksRlogOutputParser
{

    /**
     * @param rlogOutput Log file to parse for changes
     * @return If changes have been detected in the project since the previous build
     */
    public static boolean hasChanges( String rlogOutput )
    {
        if (StringUtils.isNotBlank(rlogOutput))
        {
            final String[] lines = rlogOutput.split("\\r?\\n");
            for (String line : lines)
            {
                // Skip blank lines, and various strings which it echo's out
                if (line.startsWith("Connecting to")
                || StringUtils.isBlank(line) )
                {
                    continue;
                }
                
                return true;
            }
        }

        // We think there were no changes
        return false;
    }

    
    /**
     * Parse the log file output
     */
    public static MksChangeLogSet parse(AbstractBuild<?, ?> build, String rlogOutput, TaskListener listener)
    throws Exception
    {
        MksChangeLogParser parser = new MksChangeLogParser();
        rlogOutput = "<changelog>" + rlogOutput + "</changelog>";
        hudson.scm.ChangeLogSet changeLogSet = parser.parse(build, rlogOutput);
        
        return (MksChangeLogSet)changeLogSet;
    }

}
