package mks.cmd;

import hudson.util.ArgumentListBuilder;
import mks.MksScm;

/**
 * Base class all commands should implement
 * @author James Sheets
 */
public abstract class AbstractCmd
extends ArgumentListBuilder
{
    /** Get a reference to our descriptor, so we can access the global settings **/
    protected final MksScm.DescriptorImpl desc = new MksScm.DescriptorImpl();
    
    /** Command description to print to log **/
    public abstract String getDescription();
    
    /** Max time that we'll allow the command to run.  Ignored if 0 or less **/
    public abstract int getTimeout();
}
