package mks.cmd;

import hudson.Launcher;
import java.io.IOException;

/**
 * Make all files in a directory writable.  Only usable under Windows.
 * 
 * @author James Sheets
 */
public class CmdMakeWritable
extends AbstractCmd
{

    public CmdMakeWritable(Launcher launcher)
    throws IOException
    {
        // TODO: add unix code
        if ( launcher.isUnix() )
        {
            throw new IOException( "Make Writable command not available on non-Windows machines" );
        }
        
        add( "attrib" );
        add( "-R" );
        add( "*.*" );
        add( "/s" );
        add( "/d" );
    }


    @Override
    public String getDescription()
    {
        return "Make Writable";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getWriteable();
    }

}
