package mks.cmd;

import mks.config.JobSettings;
import org.apache.commons.lang.StringUtils;

/**
 * Add a file to the sandbox
 * 
 * @author James Sheets
 */
public class MksCmdAdd 
extends AbstractMksCmd
{
    public MksCmdAdd(final JobSettings jobSettings, final String sandboxDir, final String member
            , final String issueId, final String description)
    {
        super( "add", jobSettings );
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        addKeyValuePair( "--onExistingArchive", "newarchive" );
        addKeyValuePair( "--description", description);
        if (StringUtils.isNotBlank(issueId))
        {
            if (issueId.indexOf(":") > 0)
                addKeyValuePair( "--cpid", issueId );
            else if (StringUtils.isNotBlank(issueId))
                addKeyValuePair( "--issueId", issueId );
        }
        add( "--batch" );
        add( "--includeFormers" );
        add( member );
        // TODO: --deploytype?
        // TODO: --createSubprojects?
    }


    @Override
    public String getDescription()
    {
        return "Add member";
    }


    @Override
    public int getTimeout()
    {
        return -1;
    }
}
