package mks.cmd;

import mks.config.JobSettings;

/**
 * Checkpoint a project
 * 
 * @author James Sheets
 */
public class MksCmdCheckpoint 
extends AbstractMksCmd
{

    public MksCmdCheckpoint(final JobSettings jobSettings
            , final String sandboxDir, final String description
            , final String label, final boolean labelMembers)
    {
        super( "checkpoint", jobSettings );
        
        addKeyValuePair( "--cwd", sandboxDir );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        addKeyValuePair( "--description", description );
        addKeyValuePair( "--label", label );
        if ( labelMembers )
        {
            add( "--labelMembers" );
        }
        add( "--yes" );
        add( "--quiet" );
        add( "--notify" );
    }


    @Override
    public String getDescription()
    {
        return "Checkpoint project";
    }
    

    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getCheckpoint();
    }

}
