package mks.cmd;

import java.util.Date;
import mks.MksUtils;
import mks.config.JobSettings;
import mks.config.Project;

/**
 * Checks to see if there have been changes made to the project after a specific
 * date.  Note: this doesn't not compare against the locally checked-out files.
 * 
 * @author James Sheets
 */
public class MksCmdRlog
extends AbstractMksCmd
{
    
    public MksCmdRlog(final JobSettings jobSettings
            , final int jobNumber, final Date since)
    {
        super( "rlog", jobSettings );

        final Project proj = jobSettings.getProjects().get( jobNumber );

        // We must put single quotes around dates, unless the date is empty
        String beginDate = "'" + MksUtils.formatRlogSeachDate(since) + "'";
        // No end date; freeze/thaw to keep from fetching files added after resync but before build finishes
        String endDate = "";

        // Note: Hudson puts single-quotes around arguments with spaces.
        add("--recurse");
        add("--noHeaderFormat");
        add("--noTrailerFormat");
        addKeyValuePair( "--project", proj.getConfigPath() );
        addKeyValuePair("--rfilter", "branch::current");
        addKeyValuePair("--rfilter", "anyspecial");
        addKeyValuePair("--format", MksUtils.RLOG_FORMAT);
        // ex: "daterange:'Sep 11, 2001 08:46:15 AM'-"
        addKeyValuePair("--rfilter", "daterange:" + beginDate + "-" + endDate);

        
        // This way would check to see if the sandbox is different than the head of the project
        /*addKeyValuePair("--cwd=", sandboxDir );
        addKeyValuePair("--sandbox", "project.pj");
        add("--recurse");
        add("--noHeaderFormat");
        add("--noTrailerFormat");
        addKeyValuePair("--format, MksUtils.RLOG_FORMAT);
        addKeyValuePair("--filter, "changed:missing,changed:newmem,changed:sync");
        addKeyValuePair("--filter, "!changed:working");
        addKeyValuePair("--revision, ":head");
        */
    }


    @Override
    public String getDescription()
    {
        return "Project changelog";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getRlog();
    }

}
