package mks.cmd;

import mks.config.JobSettings;

/**
 * Gets the list of files in our project that don't exist in our sandbox
 * 
 * @author James Sheets
 */
public class MksCmdRlog_MissingMembers 
extends AbstractMksCmd
{
    public MksCmdRlog_MissingMembers(final JobSettings jobSettings, final String sandbox)
    {
        super( "rlog", jobSettings );
        
        addKeyValuePair( "--cwd", sandbox );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        addKeyValuePair( "--maxTrunkRevs", "1" );
        addKeyValuePair( "--filter", "changed:missing" );
        addKeyValuePair( "--rfilter", "branch::current" );
        addKeyValuePair( "--format", "{workingfile}\n" );
        add( "--noHeaderFormat" );
        add( "--noTrailerFormat" );
        add( "--recurse" );
    }


    @Override
    public String getDescription()
    {
        return "Find missing members";
    }


    @Override
    public int getTimeout()
    {
        return -1;
    }
}
