package mks.cmd;

import mks.config.JobSettings;

/**
 * Gets the list of files in our sandbox that don't exist in the projet
 * 
 * @author James Sheets
 */
public class MksCmdRlog_NonMembers 
extends AbstractMksCmd
{
    public MksCmdRlog_NonMembers(final JobSettings jobSettings, final String sandbox)
    {
        super( "viewnonmembers", jobSettings );
        
        addKeyValuePair( "--cwd", sandbox );
        addKeyValuePair( "--sandbox", sandboxDesscriptor );
        addKeyValuePair( "--fields", "absolutepath" );
        add( "--includeFormers" );
        add( "--recurse" );
    }


    @Override
    public String getDescription()
    {
        return "Find new members";
    }


    @Override
    public int getTimeout()
    {
        return -1;
    }
}
