package mks.cmd;

import mks.config.JobSettings;
import mks.config.Project;

/**
 * Thaw a frozen project so commits may occur
 * @author James Sheets
 */
public class MksCmdThaw
extends AbstractMksCmd
{

    public MksCmdThaw(final JobSettings jobSettings
            , final int jobNumber)
    {
        super( "thaw", jobSettings );
        
        final Project proj = jobSettings.getProjects().get( jobNumber );

        addKeyValuePair( "--project", proj.getConfigPath() );
        add( "--recurse" );
    }


    @Override
    public String getDescription()
    {
        return "Project thaw";
    }


    @Override
    public int getTimeout()
    {
        return desc.getTimeoutSettings().getThaw();
    }

}
