package mks.config;

import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/**
 * The current MKS job settings
 * 
 * @author James Sheets
 */
public class JobSettings
{

    // Stapler bound variables
    private final List<Project> projects;
    private final String server;
    private final Integer port;
    private final String username;
    private final String password;
    private final Boolean freeze;
    private final Boolean cleanBeforeResync;
    private final Boolean makeWritable;
    private final String authType;


    @DataBoundConstructor
    public JobSettings(List<Project> projects, String authType
            , String server, int port, String username, String password
            , Boolean freeze, Boolean cleanBeforeResync, Boolean makeWritable )
    {
        this.projects = projects;
        this.authType = authType;
        this.server = server;
        this.port = port;
        this.username = username;
        this.password = password;
        this.freeze = freeze;
        this.cleanBeforeResync = cleanBeforeResync;
        this.makeWritable = makeWritable;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     */
    public List<Project> getProjects()
    {
        return projects;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * @see MksAuthTypeListBoxModel#CURRENT_USER
     * @see MksAuthTypeListBoxModel#SPECIFIC_USER
     * @return How we authenticate with MKS
     */
    public String getAuthType()
    {
        return authType;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * Only set when AuthType==MksAuthTypeListBoxModel.SPECIFIC_USER
     * @see #getAuthType() 
     * @return Name of the MKS server to connect to
     */
    public String getServer()
    {
        return server;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * Only set when AuthType==MksAuthTypeListBoxModel.SPECIFIC_USER
     * @see #getAuthType() 
     * @return Port the MKS server runs on
     */
    public Integer getPort()
    {
        return port;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * Only set when AuthType==MksAuthTypeListBoxModel.SPECIFIC_USER
     * @see #getAuthType() 
     * @return Name of the MKS user to login with
     */
    public String getUsername()
    {
        return username;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * Only set when AuthType==MksAuthTypeListBoxModel.SPECIFIC_USER
     * @see #getAuthType() 
     * @return Password for the MKS user to login with
     */
    public String getPassword()
    {
        return password;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * @return If we should freeze the project after checkout (and thaw post-build)
     */
    public Boolean getFreeze()
    {
        return freeze;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * @return If the sandbox should be wiped out prior to resync
     */
    public Boolean getCleanBeforeResync()
    {
        return cleanBeforeResync;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * @return If the sandbox should be made writable after checkout
     */
    public Boolean getMakeWritable()
    {
        return makeWritable;
    }

}
