package mks.config;

import hudson.util.ListBoxModel;

/**
 * @see #CURRENT_USER
 * @see #SPECIFIC_USER
 * @author James Sheets
 */
public class MksAuthTypeListBoxModel
extends ListBoxModel
{
    /**
     * Connect to MKS using whoever is currently connected through the MKS GUI
     * tool.  MKS will raise errors if the user isn't logged in.
     */
    public static final String CURRENT_USER = "currentUser";
    /**
     * Connect to MKS using a specific user account
     */
    public static final String SPECIFIC_USER = "specificUser";


    public MksAuthTypeListBoxModel()
    {
        this.add("Current GUI Session", CURRENT_USER);
        this.add("Specific Settings", SPECIFIC_USER);
    }
    
}
