package mks.config;

import org.kohsuke.stapler.DataBoundConstructor;

/**
 *
 * @author James Sheets
 */
public class Project
{
    // Stapler bound parameters
    private final String sandboxName;
    private final String configPath;
    private final Boolean checkpoint;
    private final String buildType;
    private final String projectRevision;
    private transient boolean frozen = false;

    
    @DataBoundConstructor
    public Project(String sandboxName, String configPath, Boolean checkpoint, String buildType, String projectRevision)
    {
        this.sandboxName = sandboxName;
        this.configPath = configPath;
        this.checkpoint = checkpoint;
        this.buildType = buildType;
        this.projectRevision = projectRevision;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * @return The sandbox name to check the project out to
     */
    public String getSandboxName()
    {
        return sandboxName;
    }


    /*
     * Pump saved value to <tt>config.jelly</tt>.
     * @return The MKS path for a project
     */
    public String getConfigPath()
    {
        return configPath;
    }
    
    
    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * @return If we should allow this project to be checkpointed.  Ignored
     * if when build type is set to MksBuildTypeListBoxModel#PROJECT_REVISION
     */
    public Boolean getCheckpoint()
    {
        return checkpoint;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * @see MksBuildTypeListBoxModel#TIP
     * @see MksBuildTypeListBoxModel#PROJECT_REVISION
     * @return How to pull code
     */
    public String getBuildType()
    {
        return buildType;
    }


    /**
     * Pump saved value to <tt>config.jelly</tt>.
     * Only set if the BuildType==MksBuildTypeListBoxModel.PROJECT_REVISION
     * @see #getBuildType() 
     * @return Project revision number
     */
    public String getProjectRevision()
    {
        return projectRevision;
    }
    
    
    /**
     * @param frozen whether or not we've frozen the project
     */
    public void setFrozen(boolean frozen)
    {
        this.frozen = frozen;
    }
    
    
    /**
     * @return whether or not we've frozen the project
     */
    public boolean isFrozen()
    {
        return frozen;
    }
    

    @Override
    public String toString()
    {
        return "Project {sandboxName="+sandboxName+", configPath="+configPath+"}";
    }

}
