package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;

import java.io.File;

/*
 * @author Michael Rack
 */
public class SourceIntegrityAddLabelCommand extends AbstractSourceIntegrityCommand {

    private final String _sandbox;
    private final String _label;
    private boolean _moveLabel;

    //generate an si addlabel command
    public SourceIntegrityAddLabelCommand(String server, int port, String username, String password, String sandbox, String label) {
        super("addlabel", server, port, username, password);
        _sandbox = sandbox;
        _label = label;
    }

    public ArgumentListBuilder getCommand() {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add("--sandbox=" + _sandbox + File.separator + "project.pj");
        cmd.add("--recurse");
        cmd.add("--label=" + _label);
        cmd.add("--revision=:working");
        if (_moveLabel) {
            cmd.add("--moveLabel");
        }
        return cmd;
    }

    public void setMoveLabel(boolean move) {
        _moveLabel = move;
    }
}
