package hudson.plugins.si;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.kohsuke.stapler.export.ExportedBean;

import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogSet;


/*
 * @author Michael Rack
 */
@ExportedBean(defaultVisibility = 999)
public class SourceIntegrityChangeLogSet
extends ChangeLogSet<SourceIntegrityChangeLogEntry>
{

    private List<SourceIntegrityChangeLogEntry> changes = null;


    protected SourceIntegrityChangeLogSet( AbstractBuild<?, ?> build, List<SourceIntegrityChangeLogEntry> changeEntries )
    {
        super( build );
        changes = Collections.unmodifiableList( changeEntries );
    }


    protected SourceIntegrityChangeLogSet( AbstractBuild<?, ?> build )
    {
        super( build );
        changes = new ArrayList<SourceIntegrityChangeLogEntry>();
    }


    @Override
    public boolean isEmptySet()
    {
        return changes.isEmpty();
    }


    public Iterator<SourceIntegrityChangeLogEntry> iterator()
    {
        return changes.iterator();
    }


    public void add( SourceIntegrityChangeLogEntry entry )
    {
        entry.setParent( this );
        changes.add( entry );
    }


    public SourceIntegrityChangeLogEntry getLast()
    {
        return isEmptySet() ? null : changes.get( changes.size() - 1 );
    }

}
