package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;


/*
 * @author Michael Rack
 */
public class SourceIntegrityCreateSandboxCommand
extends AbstractSourceIntegrityCommand
{

    protected final String _configurationPath;
    protected final String _workspace;
    protected String _projectrevision = null;


    /**
     * Constructor
     * @param server
     * @param port
     * @param username
     * @param password
     * @param configurationPath
     * @param workspace
     */
    public SourceIntegrityCreateSandboxCommand( final String server, final int port, final String username,
            final String password, final String configurationPath, final String workspace )
    {
        super( "createsandbox", server, port, username, password );
        _configurationPath = configurationPath;
        _workspace = workspace;
    }


    /**
     * Checkout a specific project revision
     * @param pr
     */
    public void setProjectRevision( final String pr )
    {
        _projectrevision = pr;
    }


    @Override
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add( "--project=" + _configurationPath );
        cmd.add( "--recurse" );
        cmd.add( "--cwd=" + _workspace );
        if ( _projectrevision != null ) {
            cmd.add( "--projectrevision=" + _projectrevision );
        }
        return cmd;
    }
}
