package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;


/**
 * @author Michael Rack
 *
 */
public class SourceIntegrityFreezeCommand
extends AbstractSourceIntegrityCommand
{

    private final String _configurationPath;


    /**
     * Constructor
     * @param server
     * @param port
     * @param username
     * @param password
     * @param configurationPath
     */
    public SourceIntegrityFreezeCommand( final String server, final int port, final String username,
            final String password, final String configurationPath )
    {
        super( "freeze", server, port, username, password );
        _configurationPath = configurationPath;
    }


    /**
     * @see hudson.plugins.si.SourceIntegrityCommand#getCommand()
     */
    @Override
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add( "--project=" + _configurationPath );
        cmd.add( "--recurse" );
        return cmd;
    }
}
