package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;


/**
 * @author SheeJam
 *
 */
public class SourceIntegrityProjectInfo
extends AbstractSourceIntegrityCommand
{

    protected final String _configurationPath;


    /**
     * Constructor
     * @param server
     * @param port
     * @param username
     * @param password
     * @param configurationPath
     */
    public SourceIntegrityProjectInfo( final String server, final int port, final String username
            , final String password, final String configurationPath )
    {
        super( "projectinfo", server, port, username, password );
        _configurationPath = configurationPath;
    }


    /**
     * @see hudson.plugins.si.SourceIntegrityCommand#getCommand()
     */
    @Override
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add( "--project=" + _configurationPath );
        cmd.add( "--nodevpaths" );
        cmd.add( "--noattributes" );
        cmd.add( "--noassociatedIssues" );
        cmd.add( "--noacl" );
        return cmd;
    }
}
