package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;

/**
 * @author Michael Rack
 *
 */
public abstract class AbstractSourceIntegrityCommand
implements SourceIntegrityCommand
{

    protected final String _username;
    protected final String _password;
    protected final String _server;
    protected final int _port;
    protected final String _command;


    /**
     * Constructor
     * @param command
     * @param server
     * @param port
     * @param username
     * @param password
     */
    public AbstractSourceIntegrityCommand(final String command, final String server
            , final int port, final String username, final String password)
    {
        _server = server;
        _port = port;
        _username = username;
        _password = password;
        _command = command;
    }

    /**
     * @see hudson.plugins.si.SourceIntegrityCommand#getCommand()
     */
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add( PluginImpl.SI_DESCRIPTOR.getSiExecutable() );
        cmd.add( _command );
        cmd.add( "--hostname=" + _server );
        cmd.add( "--port=" + _port );
        //cmd.add( "--batch" ); // don't use batch, as that prevents automated confirm to prompted questions
        // If no user/password specified, we'll run under the account of
        // the GUI's currently logged-in user
        if ( _username != null && _username.trim().length() > 0 )
        {
            cmd.add ("--user=" + _username );
            cmd.addMasked( "--password=" + _password );
        }
        return cmd;
    }


    /**
     * Simple convenience method to get the command as an array.
     */
    public String[] toCommandArray()
    {
        return getCommand().toCommandArray();
    }


    /**
     * Simple convenience method to get the command masking as an array.
     */
    public boolean[] toMaskArray()
    {
        return getCommand().toMaskArray();
    }


    public String toStringWithQuote()
    {
        return getCommand().toStringWithQuote();
    }


    /**
     * @return A masked password
     */
    public String toMaskedStringWithQuote()
    {
        boolean[] mask = toMaskArray();
        int i = 0;
        StringBuilder buf = new StringBuilder();
        for (String arg : toCommandArray()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (mask[i++]) {
                buf.append("*********");
            } else {
                if (arg.indexOf(' ') >= 0 || arg.length() == 0) {
                    buf.append('"').append(arg).append('"');
                } else {
                    buf.append(arg);
                }
            }
        }
        return buf.toString();
    }

}