package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;

/*
 * @author Michael Rack
 */

public interface SourceIntegrityCommand
{

    public abstract ArgumentListBuilder getCommand();


    /**
     * Simple convenience method to get the command as an array.
     */
    public abstract String[] toCommandArray();


    /**
     * Simple convenience method to get the command masking as an array.
     */
    public abstract boolean[] toMaskArray();


    public abstract String toStringWithQuote();


    /**
     * Convert the command arguments to a string with arguments containing spaces quoted
     * and sensitive arguments masked.
     * @return the command as a masked string.
     */
    public abstract String toMaskedStringWithQuote();
}
