package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;


/*
 * @author Michael Rack
 */
public class SourceIntegrityDropSandboxCommand
extends AbstractSourceIntegrityCommand
{

    private final String _sandbox;


    /**
     * Constructor
     * @param server
     * @param port
     * @param username
     * @param password
     * @param workspace
     */
    public SourceIntegrityDropSandboxCommand( final String server, final int port, String username,
            final String password, final String sandbox )
    {
        super( "dropsandbox", server, port, username, password );
        _sandbox = sandbox;
    }


    @Override
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add( "--delete=members" );
        cmd.add( "--noconfirm" );
        cmd.add( _sandbox + java.io.File.separator + "project.pj" );
        return cmd;
    }
}
