package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;

import java.io.File;

/*
 * @author Michael Rack
 */
public class SourceIntegrityResyncCommand
extends AbstractSourceIntegrityCommand
{
			
    private final String _sandbox;

    public SourceIntegrityResyncCommand(String server, int port, String username, String password, String sandbox)
    {
        super("resync", server, port, username, password);
        _sandbox = sandbox;
    }

    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add("--sandbox=" + _sandbox + File.separator + "project.pj");
        cmd.add("--recurse");
        cmd.add("--overwriteChanged");
        cmd.add("--overwriteIfPending");
        return cmd;
    }
}
