package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;


/**
 * @author SheeJam
 *
 */
public class SourceIntegrityTestSandbox
extends AbstractSourceIntegrityCommand
{

    protected final String _sandbox;


    /**
     * Constructor
     * @param server
     * @param port
     * @param username
     * @param password
     * @param sandbox
     */
    public SourceIntegrityTestSandbox( final String server, final int port,
            final String username, final String password, final String sandbox )
    {
        super( "projectinfo", server, port, username, password );
        _sandbox = sandbox;
    }


    /**
     * @see hudson.plugins.si.SourceIntegrityCommand#getCommand()
     */
    @Override
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add( "--sandbox=" + _sandbox + java.io.File.separator + "project.pj" );
        cmd.add( "--nodevpaths" );
        cmd.add( "--noattributes" );
        cmd.add( "--noassociatedIssues" );
        cmd.add( "--noacl" );
        return cmd;
    }
}
