package hudson.plugins.si;

import hudson.util.ArgumentListBuilder;


/**
 * @author Michael Rack
 *
 */
public class SourceIntegrityThawCommand
extends AbstractSourceIntegrityCommand
{

    protected final String _configurationPath;


    public SourceIntegrityThawCommand( final String server, final int port, final String username
            , final String password, final String configurationPath )
    {
        super( "thaw", server, port, username, password );
        _configurationPath = configurationPath;
    }


    /**
     * @see hudson.plugins.si.SourceIntegrityCommand#getCommand()
     */
    @Override
    public ArgumentListBuilder getCommand()
    {
        ArgumentListBuilder cmd = super.getCommand();
        cmd.add( "--project=" + _configurationPath );
        cmd.add( "--recurse" );
        return cmd;
    }
}
