import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Programmatic authentication.  Useful so we can retrieve a login/password from
 * a post or get, and then attempt to authenticate.
 * 
 * Make sure the servlet this is running on has some form of authentication enabled
 * (for Tomcat, uncomment the users in tomcat-users.xml for simple authentication)
 * 
 * You can modify the authentication type in web.xml.
 * 
 * Uses Servlet 3.0 library: you need J2EE 6.0 installed in order to compile, and 
 * you must deploy to a supported servlet container (Tomcat 7, jetty, etc)
 * 
 * To test, login to: 
 * 		http://localhost:8080/jsee6-servlet-container-authentication/TestServlet?txtUserName=tomcat&txtPassword=tomcat
 */
public class TestServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

    /**
     * Default constructor. 
     */
    public TestServlet() {
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) 
	throws ServletException, IOException {
		processRequest(request,response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) 
	throws ServletException, IOException {
		processRequest(request,response);
	}
	
	/** 
     * Processes requests for both HTTP GET and POST methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            String userName = request.getParameter("txtUserName");
            String password = request.getParameter("txtPassword");
            
            out.println("Before Login" + "<br>");
            out.println("&nbsp;&nbsp;IsUserInRole?.." + request.isUserInRole("tomcat")+"<br>");
            out.println("&nbsp;&nbsp;getRemoteUser?.." + request.getRemoteUser()+"<br>");
            out.println("&nbsp;&nbsp;getUserPrincipal?.." + request.getUserPrincipal()+"<br>");
            out.println("&nbsp;&nbsp;getAuthType?.." + request.getAuthType()+"<br><br>");
            
            try {
            	out.println("Login attempt<br>");
            	out.println("&nbsp;&nbsp;Username:" + userName + "<br>");
            	out.println("&nbsp;&nbsp;Password:" + password + "<br><br>");
                request.login(userName, password); 
            } catch(ServletException ex) {
                out.println("Login Failed with a ServletException.." + ex.getMessage());
                return;
            }
            out.println("After Login..."+"<br>");
            out.println("&nbsp;&nbsp;IsUserInRole?.." + request.isUserInRole("tomcat")+"<br>");
            out.println("&nbsp;&nbsp;getRemoteUser?.." + request.getRemoteUser()+"<br>");
            out.println("&nbsp;&nbsp;getUserPrincipal?.." + request.getUserPrincipal()+"<br>");
            out.println("&nbsp;&nbsp;getAuthType?.." + request.getAuthType()+"<br><br>");
            
            request.logout();
            out.println("After Logout..."+"<br>");
            out.println("&nbsp;&nbsp;IsUserInRole?.." + request.isUserInRole("tomcat")+"<br>");
            out.println("&nbsp;&nbsp;getRemoteUser?.." + request.getRemoteUser()+"<br>");
            out.println("&nbsp;&nbsp;getUserPrincipal?.." + request.getUserPrincipal()+"<br>");
            out.println("&nbsp;&nbsp;getAuthType?.." + request.getAuthType()+"<br>");
        } finally {
            out.close();
        }
    }

}
