/*
 * Copyright (C) 2007-2008  Alessandro Melandri
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * */

package net.melandri.jtextfileparser.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;

/**
 * @author Alessandro Melandri
 * @version 1.1
 * */
public  class FileManager {

	
	/**
	 * Metodo per comporre il fullPath ad un file
	 * 
	 * @param 	fileName 	Nome del file
	 * @param 	filePath 	Path del file
	 * 
	 * @return 	Restituisce il path completo al file
	 * 
	 * */
	public static String composeFilePath(String fileName, String filePath){
	
		String fullPath = "";
		
		String lastChar = filePath.substring( filePath.length()-1 , filePath.length() );
		
		if ( !lastChar.equals(File.separator) )
			filePath = filePath + File.separator;
		
		fullPath = filePath + fileName;
		
		return fullPath;
		
	}
	
	
	
	/**
	 * Method to load a text file form the file system
	 * 
	 * @param fullPath 	The full path (path + file name) for the text file
	 * 
	 * @return	Returns a BufferedReader for the specified text file
	 * 
	 * */
	public static BufferedReader loadTextFile(String fullPath) throws FileNotFoundException{
		
		BufferedReader buffReader = new BufferedReader( new InputStreamReader ( new FileInputStream( fullPath ) ) );
		
		return buffReader;
	}
	
}
