/*
 * Copyright (C) 2007-2008  Alessandro Melandri
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * */

package net.melandri.jtextfileparser.beans;

import java.util.TreeMap;

import net.melandri.jtextfileparser.utils.StringUtils;

/**
 * @author Alessandro Melandri
 * @version 1.2
 * */
public class Row {

	private int number;
	private String[] fields;
	private final String SEP;
	
	
	public Row(String sep){
		SEP = sep;
	}
	
	
	/**
	 * This method will return an Array of String containing the values for the choosen fields
	 * 
	 * @param positions 	Array containing the fields id you want to retrieve. 
	 * */
	public String[] getFields(int[] positions){
		
		String[] values = new String[positions.length];
		
		for (int i = 0 ; i < positions.length ; i++){
			values[i] = fields[positions[i]];
		}
		
		return values;
	}
	
	
	
	/**
	 * This method returns the value of the specified field
	 * 
	 * @param index Field position. First field ha sposition 0
	 * 
	 * @return Return the value of the specified field
	 * */
	public String get(int index){
		
		return (String) fields[index];
	}
	
	
	
	/**
	 * This method returns the number of fields in the row
	 * 
	 * @return Returns the number of fields in the row
	 * 
	 * */
	public int length(){
		
		return fields.length;
	}
	
	
	
	/**
	 * This method returns the row as a String
	 * 
	 * @deprecated Use getStringRow() instead.
	 * @return Returns the row as a String 
	 * */
	public String getSimpleRow() {
		return getStringRow();
	}
	
	
	
	/**
	 * This method returns the row as a String
	 * 
	 * @return Returns the row as a String 
	 * */
	public String getStringRow() {
		String simpleRow = "";
		
		for(int i = 0; i < fields.length ; i++){
			
			if (i != (fields.length -1))
				simpleRow += fields[i] + SEP;
			else
				simpleRow += fields[i];
		}
		
		return simpleRow;
	}
	
	
	
	/**
	 * Parses every field of the row and sobstitutes the chars specified
	 * 
	 * @param chars TreeMap containg couples oldChar-newChar
	 * */
	public void clean(TreeMap chars){
		
		if (fields != null && fields.length > 0){
			
			String[] fieldsTemp = new String[this.fields.length];
			
			for (int i = 0; i < this.fields.length ; i++){
				
				fieldsTemp[i] = StringUtils.substituteChars(fields[i], chars);
				
			}
			
			this.fields = fieldsTemp;
		}
		
	}
	
	
	/**
	 * @return Returns row's fields as a Strings array
	 * */
	public String[] getFields() {
		return fields;
	}
	
	
	
	/**
	 * Sets the row's fields
	 * 
	 * @param fields Array of Strings
	 * */
	public void setFields(String[] fields) {
		this.fields = fields;
	}
	
	
	
	/**
	 * @return The number of the row
	 * */
	public int getNumber() {
		return number;
	}
	
	
	
	/**
	 * Sets the number of the row
	 * @param number The number of the row.
	 * */
	public void setNumber(int number) {
		this.number = number;
	}
	
	
	
	/**
	 * @return The fields separator for this row.
	 * */
	public String getSEP(){
		return SEP;
	}
}
