/*
 * Copyright (C) 2007-2008 Alessandro Melandri
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package net.melandri.jtextfileparser.filters;


/**
 * Class for filtering a TextFile object. This is used to export TextFile content
 * 
 * @since 1.3.1
 * */
public class HTMLFileFilter extends TextFileFilter {

	private String pageTitle;
	private String contentBefore;
	private String contentAfter;
	private String cssFilePath;
	private boolean printFileRowNumbers = false;
	private boolean printRowNumbers = false;
	private boolean printHeaders = false;
	
	public String getPageTitle() {
		return pageTitle;
	}
	
	public void setPageTitle(String pageTitle) {
		this.pageTitle = pageTitle;
	}
	
	public String getContentBefore() {
		return contentBefore;
	}
	
	public void setContentBefore(String contentBefore) {
		this.contentBefore = contentBefore;
	}
	
	public String getContentAfter() {
		return contentAfter;
	}
	
	public void setContentAfter(String contentAfter) {
		this.contentAfter = contentAfter;
	}
	
	public boolean getPrintFileRowNumbers() {
		return printFileRowNumbers;
	}
	
	public void setPrintFileRowNumbers(boolean printFileRowNumbers) {
		this.printFileRowNumbers = printFileRowNumbers;
	}
	
	public boolean getPrintRowNumbers() {
		return printRowNumbers;
	}
	
	public void setPrintRowNumbers(boolean printRowNumbers) {
		this.printRowNumbers = printRowNumbers;
	}
	
	public boolean getPrintHeaders() {
		return printHeaders;
	}
	
	public void setPrintHeaders(boolean printHeaders) {
		this.printHeaders = printHeaders;
	}
	
	public String getCssFilePath() {
		return cssFilePath;
	}
	
	public void setCssFilePath(String cssFilePath) {
		this.cssFilePath = cssFilePath;
	}
}
