package org.kebabtycoon.model.finance;

import org.kebabtycoon.model.restaurant.Restaurant;

/**
 * @author teemu
 *
 */
public interface Bank {

	int getLoan(Restaurant restaurant, int requestedAmount);
	void payLoan(int amount, Restaurant restaurant) throws Exception;
	
	int getSizeOfMaxLoan(Restaurant restaurant);
	
	int getServiceChargePercent();
	void setServiceChargePercent(int percent);
	void billServiceCharges();
	
	/**
	 * Get startup loan from the bank required to start
	 * kebab business
	 * @param restaurant Restaurant requesting startup loan
	 * @return Returns startup loan
	 */
	int getStartupLoan(Restaurant restaurant);
}
