package org.kebabtycoon.model.finance;

import java.util.HashMap;
import java.util.Map;

import org.kebabtycoon.model.restaurant.Restaurant;

public class SimpleBankImpl implements Bank {

	private Map<String, Integer> loans;
	private int startupLoan = 100000;
	private int serviceChargePercent = 10;
	
	public SimpleBankImpl() {
		loans = new HashMap<String, Integer>();
	}
	
	@Override
	public int getLoan(Restaurant restaurant, int requestedAmount) {
		
		int loan = loans.get(restaurant.getName());
		int newLoan = loan + requestedAmount;
		
		if (newLoan > getSizeOfMaxLoan(restaurant))
			return 0;
		
		loan = newLoan;
		
		return requestedAmount;
	}

	@Override
	public int getSizeOfMaxLoan(Restaurant restaurant) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getStartupLoan(Restaurant restaurant) {
		
		return getLoan(restaurant, startupLoan);
	}

	@Override
	public void payLoan(int amount, Restaurant restaurant) throws Exception {
		
		int funds = restaurant.getFunds();
		
		if (funds < amount)
			throw new Exception("Amount of payment is greater than funds of the restaurant. Loan could not be paid.");
		
		int loan = loans.get(restaurant.getName());
		loan -= amount;
		funds -= amount;
	}

	@Override
	public void billServiceCharges() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public int getServiceChargePercent() {

		return this.serviceChargePercent;
	}

	@Override
	public void setServiceChargePercent(int percent) {
		
		this.serviceChargePercent = percent;
	}

}
